package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PlacementGroup(
    groupName: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.PlacementGroupState] = Optional.Absent,
    strategy: Optional[zio.aws.ec2.model.PlacementStrategy] = Optional.Absent,
    partitionCount: Optional[Integer] = Optional.Absent,
    groupId: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    groupArn: Optional[String] = Optional.Absent,
    spreadLevel: Optional[zio.aws.ec2.model.SpreadLevel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PlacementGroup = {
    import PlacementGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PlacementGroup
      .builder()
      .optionallyWith(groupName.map(value => value: java.lang.String))(
        _.groupName
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(strategy.map(value => value.unwrap))(_.strategy)
      .optionallyWith(partitionCount.map(value => value: java.lang.Integer))(
        _.partitionCount
      )
      .optionallyWith(groupId.map(value => value: java.lang.String))(_.groupId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(groupArn.map(value => value: java.lang.String))(
        _.groupArn
      )
      .optionallyWith(spreadLevel.map(value => value.unwrap))(_.spreadLevel)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PlacementGroup.ReadOnly =
    zio.aws.ec2.model.PlacementGroup.wrap(buildAwsValue())
}
object PlacementGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PlacementGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PlacementGroup =
      zio.aws.ec2.model.PlacementGroup(
        groupName.map(value => value),
        state.map(value => value),
        strategy.map(value => value),
        partitionCount.map(value => value),
        groupId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        groupArn.map(value => value),
        spreadLevel.map(value => value)
      )
    def groupName: Optional[String]
    def state: Optional[zio.aws.ec2.model.PlacementGroupState]
    def strategy: Optional[zio.aws.ec2.model.PlacementStrategy]
    def partitionCount: Optional[Integer]
    def groupId: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def groupArn: Optional[String]
    def spreadLevel: Optional[zio.aws.ec2.model.SpreadLevel]
    def getGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.PlacementGroupState] =
      AwsError.unwrapOptionField("state", state)
    def getStrategy: ZIO[Any, AwsError, zio.aws.ec2.model.PlacementStrategy] =
      AwsError.unwrapOptionField("strategy", strategy)
    def getPartitionCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("partitionCount", partitionCount)
    def getGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupArn", groupArn)
    def getSpreadLevel: ZIO[Any, AwsError, zio.aws.ec2.model.SpreadLevel] =
      AwsError.unwrapOptionField("spreadLevel", spreadLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PlacementGroup
  ) extends zio.aws.ec2.model.PlacementGroup.ReadOnly {
    override val groupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => value: String)
    override val state: Optional[zio.aws.ec2.model.PlacementGroupState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.PlacementGroupState.wrap(value))
    override val strategy: Optional[zio.aws.ec2.model.PlacementStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.strategy())
        .map(value => zio.aws.ec2.model.PlacementStrategy.wrap(value))
    override val partitionCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.partitionCount())
      .map(value => value: Integer)
    override val groupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupId())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val groupArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupArn())
      .map(value => value: String)
    override val spreadLevel: Optional[zio.aws.ec2.model.SpreadLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spreadLevel())
        .map(value => zio.aws.ec2.model.SpreadLevel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PlacementGroup
  ): zio.aws.ec2.model.PlacementGroup.ReadOnly = new Wrapper(impl)
}
