package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PacketHeaderStatementRequest(
    sourceAddresses: Optional[Iterable[String]] = Optional.Absent,
    destinationAddresses: Optional[Iterable[String]] = Optional.Absent,
    sourcePorts: Optional[Iterable[String]] = Optional.Absent,
    destinationPorts: Optional[Iterable[String]] = Optional.Absent,
    sourcePrefixLists: Optional[Iterable[String]] = Optional.Absent,
    destinationPrefixLists: Optional[Iterable[String]] = Optional.Absent,
    protocols: Optional[Iterable[zio.aws.ec2.model.Protocol]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PacketHeaderStatementRequest = {
    import PacketHeaderStatementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PacketHeaderStatementRequest
      .builder()
      .optionallyWith(
        sourceAddresses.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.sourceAddresses)
      .optionallyWith(
        destinationAddresses.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.destinationAddresses)
      .optionallyWith(
        sourcePorts.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.sourcePorts)
      .optionallyWith(
        destinationPorts.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.destinationPorts)
      .optionallyWith(
        sourcePrefixLists.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.sourcePrefixLists)
      .optionallyWith(
        destinationPrefixLists.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.destinationPrefixLists)
      .optionallyWith(
        protocols.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.protocolsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PacketHeaderStatementRequest.ReadOnly =
    zio.aws.ec2.model.PacketHeaderStatementRequest.wrap(buildAwsValue())
}
object PacketHeaderStatementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PacketHeaderStatementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PacketHeaderStatementRequest =
      zio.aws.ec2.model.PacketHeaderStatementRequest(
        sourceAddresses.map(value => value),
        destinationAddresses.map(value => value),
        sourcePorts.map(value => value),
        destinationPorts.map(value => value),
        sourcePrefixLists.map(value => value),
        destinationPrefixLists.map(value => value),
        protocols.map(value => value)
      )
    def sourceAddresses: Optional[List[String]]
    def destinationAddresses: Optional[List[String]]
    def sourcePorts: Optional[List[String]]
    def destinationPorts: Optional[List[String]]
    def sourcePrefixLists: Optional[List[String]]
    def destinationPrefixLists: Optional[List[String]]
    def protocols: Optional[List[zio.aws.ec2.model.Protocol]]
    def getSourceAddresses: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("sourceAddresses", sourceAddresses)
    def getDestinationAddresses: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("destinationAddresses", destinationAddresses)
    def getSourcePorts: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("sourcePorts", sourcePorts)
    def getDestinationPorts: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("destinationPorts", destinationPorts)
    def getSourcePrefixLists: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("sourcePrefixLists", sourcePrefixLists)
    def getDestinationPrefixLists: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("destinationPrefixLists", destinationPrefixLists)
    def getProtocols: ZIO[Any, AwsError, List[zio.aws.ec2.model.Protocol]] =
      AwsError.unwrapOptionField("protocols", protocols)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PacketHeaderStatementRequest
  ) extends zio.aws.ec2.model.PacketHeaderStatementRequest.ReadOnly {
    override val sourceAddresses: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceAddresses())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val destinationAddresses: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationAddresses())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val sourcePorts: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.sourcePorts())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val destinationPorts: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationPorts())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val sourcePrefixLists: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourcePrefixLists())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val destinationPrefixLists: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationPrefixLists())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val protocols: Optional[List[zio.aws.ec2.model.Protocol]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocols())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Protocol.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PacketHeaderStatementRequest
  ): zio.aws.ec2.model.PacketHeaderStatementRequest.ReadOnly = new Wrapper(impl)
}
