package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait MetricType {
  def unwrap: software.amazon.awssdk.services.ec2.model.MetricType
}
object MetricType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.MetricType
  ): zio.aws.ec2.model.MetricType = value match {
    case software.amazon.awssdk.services.ec2.model.MetricType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.MetricType.AGGREGATE_LATENCY =>
      val r = `aggregate-latency`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.MetricType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.MetricType =
      software.amazon.awssdk.services.ec2.model.MetricType.UNKNOWN_TO_SDK_VERSION
  }
  case object `aggregate-latency` extends zio.aws.ec2.model.MetricType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.MetricType =
      software.amazon.awssdk.services.ec2.model.MetricType.AGGREGATE_LATENCY
  }
}
