package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait LaunchTemplateInstanceMetadataTagsState {
  def unwrap: software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataTagsState
}
object LaunchTemplateInstanceMetadataTagsState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataTagsState
  ): zio.aws.ec2.model.LaunchTemplateInstanceMetadataTagsState = value match {
    case software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataTagsState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataTagsState.DISABLED =>
      val r = disabled
      r
    case software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataTagsState.ENABLED =>
      val r = enabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.LaunchTemplateInstanceMetadataTagsState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataTagsState =
      software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataTagsState.UNKNOWN_TO_SDK_VERSION
  }
  case object disabled
      extends zio.aws.ec2.model.LaunchTemplateInstanceMetadataTagsState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataTagsState =
      software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataTagsState.DISABLED
  }
  case object enabled
      extends zio.aws.ec2.model.LaunchTemplateInstanceMetadataTagsState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataTagsState =
      software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataTagsState.ENABLED
  }
}
