package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportVolumeResponse(
    conversionTask: Optional[zio.aws.ec2.model.ConversionTask] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImportVolumeResponse = {
    import ImportVolumeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImportVolumeResponse
      .builder()
      .optionallyWith(conversionTask.map(value => value.buildAwsValue()))(
        _.conversionTask
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ImportVolumeResponse.ReadOnly =
    zio.aws.ec2.model.ImportVolumeResponse.wrap(buildAwsValue())
}
object ImportVolumeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImportVolumeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImportVolumeResponse = zio.aws.ec2.model
      .ImportVolumeResponse(conversionTask.map(value => value.asEditable))
    def conversionTask: Optional[zio.aws.ec2.model.ConversionTask.ReadOnly]
    def getConversionTask
        : ZIO[Any, AwsError, zio.aws.ec2.model.ConversionTask.ReadOnly] =
      AwsError.unwrapOptionField("conversionTask", conversionTask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImportVolumeResponse
  ) extends zio.aws.ec2.model.ImportVolumeResponse.ReadOnly {
    override val conversionTask
        : Optional[zio.aws.ec2.model.ConversionTask.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conversionTask())
        .map(value => zio.aws.ec2.model.ConversionTask.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImportVolumeResponse
  ): zio.aws.ec2.model.ImportVolumeResponse.ReadOnly = new Wrapper(impl)
}
