package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class IdFormat(
    deadline: Optional[DateTime] = Optional.Absent,
    resource: Optional[String] = Optional.Absent,
    useLongIds: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.IdFormat = {
    import IdFormat.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IdFormat
      .builder()
      .optionallyWith(deadline.map(value => DateTime.unwrap(value): Instant))(
        _.deadline
      )
      .optionallyWith(resource.map(value => value: java.lang.String))(
        _.resource
      )
      .optionallyWith(useLongIds.map(value => value: java.lang.Boolean))(
        _.useLongIds
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IdFormat.ReadOnly =
    zio.aws.ec2.model.IdFormat.wrap(buildAwsValue())
}
object IdFormat {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.IdFormat] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IdFormat = zio.aws.ec2.model.IdFormat(
      deadline.map(value => value),
      resource.map(value => value),
      useLongIds.map(value => value)
    )
    def deadline: Optional[DateTime]
    def resource: Optional[String]
    def useLongIds: Optional[Boolean]
    def getDeadline: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("deadline", deadline)
    def getResource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resource", resource)
    def getUseLongIds: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("useLongIds", useLongIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IdFormat
  ) extends zio.aws.ec2.model.IdFormat.ReadOnly {
    override val deadline: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.deadline())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val resource: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resource())
      .map(value => value: String)
    override val useLongIds: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.useLongIds())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IdFormat
  ): zio.aws.ec2.model.IdFormat.ReadOnly = new Wrapper(impl)
}
