package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetIpamDiscoveredAccountsResponse(
    ipamDiscoveredAccounts: Optional[
      Iterable[zio.aws.ec2.model.IpamDiscoveredAccount]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredAccountsResponse = {
    import GetIpamDiscoveredAccountsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredAccountsResponse
      .builder()
      .optionallyWith(
        ipamDiscoveredAccounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipamDiscoveredAccounts)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetIpamDiscoveredAccountsResponse.ReadOnly =
    zio.aws.ec2.model.GetIpamDiscoveredAccountsResponse.wrap(buildAwsValue())
}
object GetIpamDiscoveredAccountsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredAccountsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetIpamDiscoveredAccountsResponse =
      zio.aws.ec2.model.GetIpamDiscoveredAccountsResponse(
        ipamDiscoveredAccounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def ipamDiscoveredAccounts
        : Optional[List[zio.aws.ec2.model.IpamDiscoveredAccount.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getIpamDiscoveredAccounts: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.IpamDiscoveredAccount.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "ipamDiscoveredAccounts",
      ipamDiscoveredAccounts
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredAccountsResponse
  ) extends zio.aws.ec2.model.GetIpamDiscoveredAccountsResponse.ReadOnly {
    override val ipamDiscoveredAccounts
        : Optional[List[zio.aws.ec2.model.IpamDiscoveredAccount.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipamDiscoveredAccounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.IpamDiscoveredAccount.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredAccountsResponse
  ): zio.aws.ec2.model.GetIpamDiscoveredAccountsResponse.ReadOnly = new Wrapper(
    impl
  )
}
