package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeTransitGatewayRouteTableAnnouncementsResponse(
    transitGatewayRouteTableAnnouncements: Optional[
      Iterable[zio.aws.ec2.model.TransitGatewayRouteTableAnnouncement]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTableAnnouncementsResponse = {
    import DescribeTransitGatewayRouteTableAnnouncementsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTableAnnouncementsResponse
      .builder()
      .optionallyWith(
        transitGatewayRouteTableAnnouncements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitGatewayRouteTableAnnouncements)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeTransitGatewayRouteTableAnnouncementsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeTransitGatewayRouteTableAnnouncementsResponse
      .wrap(buildAwsValue())
}
object DescribeTransitGatewayRouteTableAnnouncementsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTableAnnouncementsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeTransitGatewayRouteTableAnnouncementsResponse =
      zio.aws.ec2.model.DescribeTransitGatewayRouteTableAnnouncementsResponse(
        transitGatewayRouteTableAnnouncements.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def transitGatewayRouteTableAnnouncements: Optional[
      List[zio.aws.ec2.model.TransitGatewayRouteTableAnnouncement.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getTransitGatewayRouteTableAnnouncements: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TransitGatewayRouteTableAnnouncement.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "transitGatewayRouteTableAnnouncements",
      transitGatewayRouteTableAnnouncements
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTableAnnouncementsResponse
  ) extends zio.aws.ec2.model.DescribeTransitGatewayRouteTableAnnouncementsResponse.ReadOnly {
    override val transitGatewayRouteTableAnnouncements: Optional[
      List[zio.aws.ec2.model.TransitGatewayRouteTableAnnouncement.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayRouteTableAnnouncements())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TransitGatewayRouteTableAnnouncement.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTableAnnouncementsResponse
  ): zio.aws.ec2.model.DescribeTransitGatewayRouteTableAnnouncementsResponse.ReadOnly =
    new Wrapper(impl)
}
