package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeSpotFleetRequestsResponse(
    nextToken: Optional[String] = Optional.Absent,
    spotFleetRequestConfigs: Optional[
      Iterable[zio.aws.ec2.model.SpotFleetRequestConfig]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsResponse = {
    import DescribeSpotFleetRequestsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        spotFleetRequestConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.spotFleetRequestConfigs)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeSpotFleetRequestsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeSpotFleetRequestsResponse.wrap(buildAwsValue())
}
object DescribeSpotFleetRequestsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSpotFleetRequestsResponse =
      zio.aws.ec2.model.DescribeSpotFleetRequestsResponse(
        nextToken.map(value => value),
        spotFleetRequestConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def spotFleetRequestConfigs
        : Optional[List[zio.aws.ec2.model.SpotFleetRequestConfig.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSpotFleetRequestConfigs: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.SpotFleetRequestConfig.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "spotFleetRequestConfigs",
      spotFleetRequestConfigs
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsResponse
  ) extends zio.aws.ec2.model.DescribeSpotFleetRequestsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val spotFleetRequestConfigs
        : Optional[List[zio.aws.ec2.model.SpotFleetRequestConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spotFleetRequestConfigs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.SpotFleetRequestConfig.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsResponse
  ): zio.aws.ec2.model.DescribeSpotFleetRequestsResponse.ReadOnly = new Wrapper(
    impl
  )
}
