package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class DescribeSpotFleetRequestHistoryResponse(
    historyRecords: Optional[Iterable[zio.aws.ec2.model.HistoryRecord]] =
      Optional.Absent,
    lastEvaluatedTime: Optional[DateTime] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    spotFleetRequestId: Optional[String] = Optional.Absent,
    startTime: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryResponse = {
    import DescribeSpotFleetRequestHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryResponse
      .builder()
      .optionallyWith(
        historyRecords.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.historyRecords)
      .optionallyWith(
        lastEvaluatedTime.map(value => DateTime.unwrap(value): Instant)
      )(_.lastEvaluatedTime)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(spotFleetRequestId.map(value => value: java.lang.String))(
        _.spotFleetRequestId
      )
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeSpotFleetRequestHistoryResponse.ReadOnly =
    zio.aws.ec2.model.DescribeSpotFleetRequestHistoryResponse
      .wrap(buildAwsValue())
}
object DescribeSpotFleetRequestHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSpotFleetRequestHistoryResponse =
      zio.aws.ec2.model.DescribeSpotFleetRequestHistoryResponse(
        historyRecords.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastEvaluatedTime.map(value => value),
        nextToken.map(value => value),
        spotFleetRequestId.map(value => value),
        startTime.map(value => value)
      )
    def historyRecords: Optional[List[zio.aws.ec2.model.HistoryRecord.ReadOnly]]
    def lastEvaluatedTime: Optional[DateTime]
    def nextToken: Optional[String]
    def spotFleetRequestId: Optional[String]
    def startTime: Optional[DateTime]
    def getHistoryRecords
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.HistoryRecord.ReadOnly]] =
      AwsError.unwrapOptionField("historyRecords", historyRecords)
    def getLastEvaluatedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastEvaluatedTime", lastEvaluatedTime)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSpotFleetRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spotFleetRequestId", spotFleetRequestId)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryResponse
  ) extends zio.aws.ec2.model.DescribeSpotFleetRequestHistoryResponse.ReadOnly {
    override val historyRecords
        : Optional[List[zio.aws.ec2.model.HistoryRecord.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.historyRecords())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.HistoryRecord.wrap(item)
          }.toList
        )
    override val lastEvaluatedTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastEvaluatedTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val spotFleetRequestId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.spotFleetRequestId())
      .map(value => value: String)
    override val startTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryResponse
  ): zio.aws.ec2.model.DescribeSpotFleetRequestHistoryResponse.ReadOnly =
    new Wrapper(impl)
}
