package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{PoolMaxResults, NextToken, Ipv4PoolEc2Id}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribePublicIpv4PoolsRequest(
    poolIds: Optional[Iterable[Ipv4PoolEc2Id]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[PoolMaxResults] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsRequest = {
    import DescribePublicIpv4PoolsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsRequest
      .builder()
      .optionallyWith(
        poolIds.map(value =>
          value.map { item =>
            Ipv4PoolEc2Id.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.poolIds)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => PoolMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribePublicIpv4PoolsRequest.ReadOnly =
    zio.aws.ec2.model.DescribePublicIpv4PoolsRequest.wrap(buildAwsValue())
}
object DescribePublicIpv4PoolsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribePublicIpv4PoolsRequest =
      zio.aws.ec2.model.DescribePublicIpv4PoolsRequest(
        poolIds.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def poolIds: Optional[List[Ipv4PoolEc2Id]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[PoolMaxResults]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def getPoolIds: ZIO[Any, AwsError, List[Ipv4PoolEc2Id]] =
      AwsError.unwrapOptionField("poolIds", poolIds)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PoolMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsRequest
  ) extends zio.aws.ec2.model.DescribePublicIpv4PoolsRequest.ReadOnly {
    override val poolIds: Optional[List[Ipv4PoolEc2Id]] = zio.aws.core.internal
      .optionalFromNullable(impl.poolIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.Ipv4PoolEc2Id(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val maxResults: Optional[PoolMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.PoolMaxResults(value))
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsRequest
  ): zio.aws.ec2.model.DescribePublicIpv4PoolsRequest.ReadOnly = new Wrapper(
    impl
  )
}
