package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NextToken,
  DescribeFastSnapshotRestoresMaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeFastSnapshotRestoresRequest(
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[DescribeFastSnapshotRestoresMaxResults] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresRequest = {
    import DescribeFastSnapshotRestoresRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          DescribeFastSnapshotRestoresMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeFastSnapshotRestoresRequest.ReadOnly =
    zio.aws.ec2.model.DescribeFastSnapshotRestoresRequest.wrap(buildAwsValue())
}
object DescribeFastSnapshotRestoresRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeFastSnapshotRestoresRequest =
      zio.aws.ec2.model.DescribeFastSnapshotRestoresRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[DescribeFastSnapshotRestoresMaxResults]
    def nextToken: Optional[NextToken]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeFastSnapshotRestoresMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresRequest
  ) extends zio.aws.ec2.model.DescribeFastSnapshotRestoresRequest.ReadOnly {
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[DescribeFastSnapshotRestoresMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeFastSnapshotRestoresMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresRequest
  ): zio.aws.ec2.model.DescribeFastSnapshotRestoresRequest.ReadOnly =
    new Wrapper(impl)
}
