package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAddressesAttributeResponse(
    addresses: Optional[Iterable[zio.aws.ec2.model.AddressAttribute]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeResponse = {
    import DescribeAddressesAttributeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeResponse
      .builder()
      .optionallyWith(
        addresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addresses)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeAddressesAttributeResponse.ReadOnly =
    zio.aws.ec2.model.DescribeAddressesAttributeResponse.wrap(buildAwsValue())
}
object DescribeAddressesAttributeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeAddressesAttributeResponse =
      zio.aws.ec2.model.DescribeAddressesAttributeResponse(
        addresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def addresses: Optional[List[zio.aws.ec2.model.AddressAttribute.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getAddresses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AddressAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("addresses", addresses)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeResponse
  ) extends zio.aws.ec2.model.DescribeAddressesAttributeResponse.ReadOnly {
    override val addresses
        : Optional[List[zio.aws.ec2.model.AddressAttribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AddressAttribute.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeResponse
  ): zio.aws.ec2.model.DescribeAddressesAttributeResponse.ReadOnly =
    new Wrapper(impl)
}
