package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVerifiedAccessTrustProviderResponse(
    verifiedAccessTrustProvider: Optional[
      zio.aws.ec2.model.VerifiedAccessTrustProvider
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessTrustProviderResponse = {
    import CreateVerifiedAccessTrustProviderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessTrustProviderResponse
      .builder()
      .optionallyWith(
        verifiedAccessTrustProvider.map(value => value.buildAwsValue())
      )(_.verifiedAccessTrustProvider)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateVerifiedAccessTrustProviderResponse.ReadOnly =
    zio.aws.ec2.model.CreateVerifiedAccessTrustProviderResponse
      .wrap(buildAwsValue())
}
object CreateVerifiedAccessTrustProviderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessTrustProviderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.CreateVerifiedAccessTrustProviderResponse =
      zio.aws.ec2.model.CreateVerifiedAccessTrustProviderResponse(
        verifiedAccessTrustProvider.map(value => value.asEditable)
      )
    def verifiedAccessTrustProvider
        : Optional[zio.aws.ec2.model.VerifiedAccessTrustProvider.ReadOnly]
    def getVerifiedAccessTrustProvider: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessTrustProvider.ReadOnly
    ] = AwsError.unwrapOptionField(
      "verifiedAccessTrustProvider",
      verifiedAccessTrustProvider
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessTrustProviderResponse
  ) extends zio.aws.ec2.model.CreateVerifiedAccessTrustProviderResponse.ReadOnly {
    override val verifiedAccessTrustProvider
        : Optional[zio.aws.ec2.model.VerifiedAccessTrustProvider.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessTrustProvider())
        .map(value => zio.aws.ec2.model.VerifiedAccessTrustProvider.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessTrustProviderResponse
  ): zio.aws.ec2.model.CreateVerifiedAccessTrustProviderResponse.ReadOnly =
    new Wrapper(impl)
}
