package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  PrivateIpAddressCount,
  SubnetId,
  AllocationId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateNatGatewayRequest(
    allocationId: Optional[AllocationId] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    subnetId: SubnetId,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    connectivityType: Optional[zio.aws.ec2.model.ConnectivityType] =
      Optional.Absent,
    privateIpAddress: Optional[String] = Optional.Absent,
    secondaryAllocationIds: Optional[Iterable[AllocationId]] = Optional.Absent,
    secondaryPrivateIpAddresses: Optional[Iterable[String]] = Optional.Absent,
    secondaryPrivateIpAddressCount: Optional[PrivateIpAddressCount] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateNatGatewayRequest = {
    import CreateNatGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateNatGatewayRequest
      .builder()
      .optionallyWith(
        allocationId.map(value => AllocationId.unwrap(value): java.lang.String)
      )(_.allocationId)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .subnetId(SubnetId.unwrap(subnetId): java.lang.String)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(connectivityType.map(value => value.unwrap))(
        _.connectivityType
      )
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .optionallyWith(
        secondaryAllocationIds.map(value =>
          value.map { item =>
            AllocationId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.secondaryAllocationIds)
      .optionallyWith(
        secondaryPrivateIpAddresses.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.secondaryPrivateIpAddresses)
      .optionallyWith(
        secondaryPrivateIpAddressCount.map(value =>
          PrivateIpAddressCount.unwrap(value): Integer
        )
      )(_.secondaryPrivateIpAddressCount)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateNatGatewayRequest.ReadOnly =
    zio.aws.ec2.model.CreateNatGatewayRequest.wrap(buildAwsValue())
}
object CreateNatGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateNatGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateNatGatewayRequest =
      zio.aws.ec2.model.CreateNatGatewayRequest(
        allocationId.map(value => value),
        clientToken.map(value => value),
        subnetId,
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        connectivityType.map(value => value),
        privateIpAddress.map(value => value),
        secondaryAllocationIds.map(value => value),
        secondaryPrivateIpAddresses.map(value => value),
        secondaryPrivateIpAddressCount.map(value => value)
      )
    def allocationId: Optional[AllocationId]
    def clientToken: Optional[String]
    def subnetId: SubnetId
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def connectivityType: Optional[zio.aws.ec2.model.ConnectivityType]
    def privateIpAddress: Optional[String]
    def secondaryAllocationIds: Optional[List[AllocationId]]
    def secondaryPrivateIpAddresses: Optional[List[String]]
    def secondaryPrivateIpAddressCount: Optional[PrivateIpAddressCount]
    def getAllocationId: ZIO[Any, AwsError, AllocationId] =
      AwsError.unwrapOptionField("allocationId", allocationId)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getSubnetId: ZIO[Any, Nothing, SubnetId] = ZIO.succeed(subnetId)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getConnectivityType
        : ZIO[Any, AwsError, zio.aws.ec2.model.ConnectivityType] =
      AwsError.unwrapOptionField("connectivityType", connectivityType)
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getSecondaryAllocationIds: ZIO[Any, AwsError, List[AllocationId]] =
      AwsError.unwrapOptionField(
        "secondaryAllocationIds",
        secondaryAllocationIds
      )
    def getSecondaryPrivateIpAddresses: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "secondaryPrivateIpAddresses",
        secondaryPrivateIpAddresses
      )
    def getSecondaryPrivateIpAddressCount
        : ZIO[Any, AwsError, PrivateIpAddressCount] =
      AwsError.unwrapOptionField(
        "secondaryPrivateIpAddressCount",
        secondaryPrivateIpAddressCount
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateNatGatewayRequest
  ) extends zio.aws.ec2.model.CreateNatGatewayRequest.ReadOnly {
    override val allocationId: Optional[AllocationId] = zio.aws.core.internal
      .optionalFromNullable(impl.allocationId())
      .map(value => zio.aws.ec2.model.primitives.AllocationId(value))
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val subnetId: SubnetId =
      zio.aws.ec2.model.primitives.SubnetId(impl.subnetId())
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val connectivityType
        : Optional[zio.aws.ec2.model.ConnectivityType] = zio.aws.core.internal
      .optionalFromNullable(impl.connectivityType())
      .map(value => zio.aws.ec2.model.ConnectivityType.wrap(value))
    override val privateIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateIpAddress())
      .map(value => value: String)
    override val secondaryAllocationIds: Optional[List[AllocationId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondaryAllocationIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.AllocationId(item)
          }.toList
        )
    override val secondaryPrivateIpAddresses: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondaryPrivateIpAddresses())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val secondaryPrivateIpAddressCount
        : Optional[PrivateIpAddressCount] = zio.aws.core.internal
      .optionalFromNullable(impl.secondaryPrivateIpAddressCount())
      .map(value => zio.aws.ec2.model.primitives.PrivateIpAddressCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateNatGatewayRequest
  ): zio.aws.ec2.model.CreateNatGatewayRequest.ReadOnly = new Wrapper(impl)
}
