package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClientVpnConnection(
    clientVpnEndpointId: Optional[String] = Optional.Absent,
    timestamp: Optional[String] = Optional.Absent,
    connectionId: Optional[String] = Optional.Absent,
    username: Optional[String] = Optional.Absent,
    connectionEstablishedTime: Optional[String] = Optional.Absent,
    ingressBytes: Optional[String] = Optional.Absent,
    egressBytes: Optional[String] = Optional.Absent,
    ingressPackets: Optional[String] = Optional.Absent,
    egressPackets: Optional[String] = Optional.Absent,
    clientIp: Optional[String] = Optional.Absent,
    commonName: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.ec2.model.ClientVpnConnectionStatus] =
      Optional.Absent,
    connectionEndTime: Optional[String] = Optional.Absent,
    postureComplianceStatuses: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ClientVpnConnection = {
    import ClientVpnConnection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ClientVpnConnection
      .builder()
      .optionallyWith(
        clientVpnEndpointId.map(value => value: java.lang.String)
      )(_.clientVpnEndpointId)
      .optionallyWith(timestamp.map(value => value: java.lang.String))(
        _.timestamp
      )
      .optionallyWith(connectionId.map(value => value: java.lang.String))(
        _.connectionId
      )
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(
        connectionEstablishedTime.map(value => value: java.lang.String)
      )(_.connectionEstablishedTime)
      .optionallyWith(ingressBytes.map(value => value: java.lang.String))(
        _.ingressBytes
      )
      .optionallyWith(egressBytes.map(value => value: java.lang.String))(
        _.egressBytes
      )
      .optionallyWith(ingressPackets.map(value => value: java.lang.String))(
        _.ingressPackets
      )
      .optionallyWith(egressPackets.map(value => value: java.lang.String))(
        _.egressPackets
      )
      .optionallyWith(clientIp.map(value => value: java.lang.String))(
        _.clientIp
      )
      .optionallyWith(commonName.map(value => value: java.lang.String))(
        _.commonName
      )
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(connectionEndTime.map(value => value: java.lang.String))(
        _.connectionEndTime
      )
      .optionallyWith(
        postureComplianceStatuses.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.postureComplianceStatuses)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ClientVpnConnection.ReadOnly =
    zio.aws.ec2.model.ClientVpnConnection.wrap(buildAwsValue())
}
object ClientVpnConnection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ClientVpnConnection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ClientVpnConnection =
      zio.aws.ec2.model.ClientVpnConnection(
        clientVpnEndpointId.map(value => value),
        timestamp.map(value => value),
        connectionId.map(value => value),
        username.map(value => value),
        connectionEstablishedTime.map(value => value),
        ingressBytes.map(value => value),
        egressBytes.map(value => value),
        ingressPackets.map(value => value),
        egressPackets.map(value => value),
        clientIp.map(value => value),
        commonName.map(value => value),
        status.map(value => value.asEditable),
        connectionEndTime.map(value => value),
        postureComplianceStatuses.map(value => value)
      )
    def clientVpnEndpointId: Optional[String]
    def timestamp: Optional[String]
    def connectionId: Optional[String]
    def username: Optional[String]
    def connectionEstablishedTime: Optional[String]
    def ingressBytes: Optional[String]
    def egressBytes: Optional[String]
    def ingressPackets: Optional[String]
    def egressPackets: Optional[String]
    def clientIp: Optional[String]
    def commonName: Optional[String]
    def status: Optional[zio.aws.ec2.model.ClientVpnConnectionStatus.ReadOnly]
    def connectionEndTime: Optional[String]
    def postureComplianceStatuses: Optional[List[String]]
    def getClientVpnEndpointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientVpnEndpointId", clientVpnEndpointId)
    def getTimestamp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getConnectionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("connectionId", connectionId)
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getConnectionEstablishedTime: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("connectionEstablishedTime", connectionEstablishedTime)
    def getIngressBytes: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ingressBytes", ingressBytes)
    def getEgressBytes: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("egressBytes", egressBytes)
    def getIngressPackets: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ingressPackets", ingressPackets)
    def getEgressPackets: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("egressPackets", egressPackets)
    def getClientIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientIp", clientIp)
    def getCommonName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("commonName", commonName)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ClientVpnConnectionStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getConnectionEndTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("connectionEndTime", connectionEndTime)
    def getPostureComplianceStatuses: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "postureComplianceStatuses",
        postureComplianceStatuses
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ClientVpnConnection
  ) extends zio.aws.ec2.model.ClientVpnConnection.ReadOnly {
    override val clientVpnEndpointId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientVpnEndpointId())
      .map(value => value: String)
    override val timestamp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => value: String)
    override val connectionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionId())
      .map(value => value: String)
    override val username: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => value: String)
    override val connectionEstablishedTime: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionEstablishedTime())
        .map(value => value: String)
    override val ingressBytes: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ingressBytes())
      .map(value => value: String)
    override val egressBytes: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.egressBytes())
      .map(value => value: String)
    override val ingressPackets: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ingressPackets())
      .map(value => value: String)
    override val egressPackets: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.egressPackets())
      .map(value => value: String)
    override val clientIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientIp())
      .map(value => value: String)
    override val commonName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.commonName())
      .map(value => value: String)
    override val status
        : Optional[zio.aws.ec2.model.ClientVpnConnectionStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ec2.model.ClientVpnConnectionStatus.wrap(value))
    override val connectionEndTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionEndTime())
      .map(value => value: String)
    override val postureComplianceStatuses: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.postureComplianceStatuses())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ClientVpnConnection
  ): zio.aws.ec2.model.ClientVpnConnection.ReadOnly = new Wrapper(impl)
}
