package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClientConnectResponseOptions(
    enabled: Optional[Boolean] = Optional.Absent,
    lambdaFunctionArn: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.ec2.model.ClientVpnEndpointAttributeStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ClientConnectResponseOptions = {
    import ClientConnectResponseOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ClientConnectResponseOptions
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(lambdaFunctionArn.map(value => value: java.lang.String))(
        _.lambdaFunctionArn
      )
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ClientConnectResponseOptions.ReadOnly =
    zio.aws.ec2.model.ClientConnectResponseOptions.wrap(buildAwsValue())
}
object ClientConnectResponseOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ClientConnectResponseOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ClientConnectResponseOptions =
      zio.aws.ec2.model.ClientConnectResponseOptions(
        enabled.map(value => value),
        lambdaFunctionArn.map(value => value),
        status.map(value => value.asEditable)
      )
    def enabled: Optional[Boolean]
    def lambdaFunctionArn: Optional[String]
    def status
        : Optional[zio.aws.ec2.model.ClientVpnEndpointAttributeStatus.ReadOnly]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getLambdaFunctionArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lambdaFunctionArn", lambdaFunctionArn)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ClientVpnEndpointAttributeStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ClientConnectResponseOptions
  ) extends zio.aws.ec2.model.ClientConnectResponseOptions.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val lambdaFunctionArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaFunctionArn())
      .map(value => value: String)
    override val status: Optional[
      zio.aws.ec2.model.ClientVpnEndpointAttributeStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.ec2.model.ClientVpnEndpointAttributeStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ClientConnectResponseOptions
  ): zio.aws.ec2.model.ClientConnectResponseOptions.ReadOnly = new Wrapper(impl)
}
