package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AuthorizeSecurityGroupIngressResponse(
    returnValue: Optional[Boolean] = Optional.Absent,
    securityGroupRules: Optional[
      Iterable[zio.aws.ec2.model.SecurityGroupRule]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupIngressResponse = {
    import AuthorizeSecurityGroupIngressResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupIngressResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .optionallyWith(
        securityGroupRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityGroupRules)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AuthorizeSecurityGroupIngressResponse.ReadOnly =
    zio.aws.ec2.model.AuthorizeSecurityGroupIngressResponse
      .wrap(buildAwsValue())
}
object AuthorizeSecurityGroupIngressResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupIngressResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AuthorizeSecurityGroupIngressResponse =
      zio.aws.ec2.model.AuthorizeSecurityGroupIngressResponse(
        returnValue.map(value => value),
        securityGroupRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def returnValue: Optional[Boolean]
    def securityGroupRules
        : Optional[List[zio.aws.ec2.model.SecurityGroupRule.ReadOnly]]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
    def getSecurityGroupRules: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.SecurityGroupRule.ReadOnly
    ]] = AwsError.unwrapOptionField("securityGroupRules", securityGroupRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupIngressResponse
  ) extends zio.aws.ec2.model.AuthorizeSecurityGroupIngressResponse.ReadOnly {
    override val returnValue: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.returnValue())
      .map(value => value: Boolean)
    override val securityGroupRules
        : Optional[List[zio.aws.ec2.model.SecurityGroupRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.SecurityGroupRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupIngressResponse
  ): zio.aws.ec2.model.AuthorizeSecurityGroupIngressResponse.ReadOnly =
    new Wrapper(impl)
}
