package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateTrunkInterfaceResponse(
    interfaceAssociation: Optional[
      zio.aws.ec2.model.TrunkInterfaceAssociation
    ] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateTrunkInterfaceResponse = {
    import AssociateTrunkInterfaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateTrunkInterfaceResponse
      .builder()
      .optionallyWith(interfaceAssociation.map(value => value.buildAwsValue()))(
        _.interfaceAssociation
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AssociateTrunkInterfaceResponse.ReadOnly =
    zio.aws.ec2.model.AssociateTrunkInterfaceResponse.wrap(buildAwsValue())
}
object AssociateTrunkInterfaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateTrunkInterfaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssociateTrunkInterfaceResponse =
      zio.aws.ec2.model.AssociateTrunkInterfaceResponse(
        interfaceAssociation.map(value => value.asEditable),
        clientToken.map(value => value)
      )
    def interfaceAssociation
        : Optional[zio.aws.ec2.model.TrunkInterfaceAssociation.ReadOnly]
    def clientToken: Optional[String]
    def getInterfaceAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TrunkInterfaceAssociation.ReadOnly
    ] = AwsError.unwrapOptionField("interfaceAssociation", interfaceAssociation)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateTrunkInterfaceResponse
  ) extends zio.aws.ec2.model.AssociateTrunkInterfaceResponse.ReadOnly {
    override val interfaceAssociation
        : Optional[zio.aws.ec2.model.TrunkInterfaceAssociation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.interfaceAssociation())
        .map(value => zio.aws.ec2.model.TrunkInterfaceAssociation.wrap(value))
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateTrunkInterfaceResponse
  ): zio.aws.ec2.model.AssociateTrunkInterfaceResponse.ReadOnly = new Wrapper(
    impl
  )
}
