package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SecurityGroupId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ApplySecurityGroupsToClientVpnTargetNetworkResponse(
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkResponse = {
    import ApplySecurityGroupsToClientVpnTargetNetworkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkResponse
      .builder()
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkResponse.ReadOnly =
    zio.aws.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkResponse
      .wrap(buildAwsValue())
}
object ApplySecurityGroupsToClientVpnTargetNetworkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkResponse =
      zio.aws.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkResponse(
        securityGroupIds.map(value => value)
      )
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkResponse
  ) extends zio.aws.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkResponse.ReadOnly {
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.SecurityGroupId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkResponse
  ): zio.aws.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkResponse.ReadOnly =
    new Wrapper(impl)
}
