package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait VolumeType {
  def unwrap: software.amazon.awssdk.services.ec2.model.VolumeType
}
object VolumeType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.VolumeType
  ): zio.aws.ec2.model.VolumeType = value match {
    case software.amazon.awssdk.services.ec2.model.VolumeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.VolumeType.STANDARD =>
      val r = standard
      r
    case software.amazon.awssdk.services.ec2.model.VolumeType.IO1 =>
      val r = io1
      r
    case software.amazon.awssdk.services.ec2.model.VolumeType.IO2 =>
      val r = io2
      r
    case software.amazon.awssdk.services.ec2.model.VolumeType.GP2 =>
      val r = gp2
      r
    case software.amazon.awssdk.services.ec2.model.VolumeType.SC1 =>
      val r = sc1
      r
    case software.amazon.awssdk.services.ec2.model.VolumeType.ST1 =>
      val r = st1
      r
    case software.amazon.awssdk.services.ec2.model.VolumeType.GP3 =>
      val r = gp3
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.VolumeType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VolumeType =
      software.amazon.awssdk.services.ec2.model.VolumeType.UNKNOWN_TO_SDK_VERSION
  }
  case object standard extends zio.aws.ec2.model.VolumeType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VolumeType =
      software.amazon.awssdk.services.ec2.model.VolumeType.STANDARD
  }
  case object io1 extends zio.aws.ec2.model.VolumeType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VolumeType =
      software.amazon.awssdk.services.ec2.model.VolumeType.IO1
  }
  case object io2 extends zio.aws.ec2.model.VolumeType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VolumeType =
      software.amazon.awssdk.services.ec2.model.VolumeType.IO2
  }
  case object gp2 extends zio.aws.ec2.model.VolumeType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VolumeType =
      software.amazon.awssdk.services.ec2.model.VolumeType.GP2
  }
  case object sc1 extends zio.aws.ec2.model.VolumeType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VolumeType =
      software.amazon.awssdk.services.ec2.model.VolumeType.SC1
  }
  case object st1 extends zio.aws.ec2.model.VolumeType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VolumeType =
      software.amazon.awssdk.services.ec2.model.VolumeType.ST1
  }
  case object gp3 extends zio.aws.ec2.model.VolumeType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.VolumeType =
      software.amazon.awssdk.services.ec2.model.VolumeType.GP3
  }
}
