package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{Integer, DateTime}
import scala.jdk.CollectionConverters._
final case class Volume(
    attachments: Optional[Iterable[zio.aws.ec2.model.VolumeAttachment]] =
      Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    createTime: Optional[DateTime] = Optional.Absent,
    encrypted: Optional[Boolean] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    outpostArn: Optional[String] = Optional.Absent,
    size: Optional[Integer] = Optional.Absent,
    snapshotId: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.VolumeState] = Optional.Absent,
    volumeId: Optional[String] = Optional.Absent,
    iops: Optional[Integer] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    volumeType: Optional[zio.aws.ec2.model.VolumeType] = Optional.Absent,
    fastRestored: Optional[Boolean] = Optional.Absent,
    multiAttachEnabled: Optional[Boolean] = Optional.Absent,
    throughput: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Volume = {
    import Volume.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Volume
      .builder()
      .optionallyWith(
        attachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachments)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(createTime.map(value => DateTime.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(size.map(value => value: java.lang.Integer))(_.size)
      .optionallyWith(snapshotId.map(value => value: java.lang.String))(
        _.snapshotId
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(volumeId.map(value => value: java.lang.String))(
        _.volumeId
      )
      .optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(volumeType.map(value => value.unwrap))(_.volumeType)
      .optionallyWith(fastRestored.map(value => value: java.lang.Boolean))(
        _.fastRestored
      )
      .optionallyWith(
        multiAttachEnabled.map(value => value: java.lang.Boolean)
      )(_.multiAttachEnabled)
      .optionallyWith(throughput.map(value => value: java.lang.Integer))(
        _.throughput
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Volume.ReadOnly =
    zio.aws.ec2.model.Volume.wrap(buildAwsValue())
}
object Volume {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Volume] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Volume = zio.aws.ec2.model.Volume(
      attachments.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      availabilityZone.map(value => value),
      createTime.map(value => value),
      encrypted.map(value => value),
      kmsKeyId.map(value => value),
      outpostArn.map(value => value),
      size.map(value => value),
      snapshotId.map(value => value),
      state.map(value => value),
      volumeId.map(value => value),
      iops.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      volumeType.map(value => value),
      fastRestored.map(value => value),
      multiAttachEnabled.map(value => value),
      throughput.map(value => value)
    )
    def attachments: Optional[List[zio.aws.ec2.model.VolumeAttachment.ReadOnly]]
    def availabilityZone: Optional[String]
    def createTime: Optional[DateTime]
    def encrypted: Optional[Boolean]
    def kmsKeyId: Optional[String]
    def outpostArn: Optional[String]
    def size: Optional[Integer]
    def snapshotId: Optional[String]
    def state: Optional[zio.aws.ec2.model.VolumeState]
    def volumeId: Optional[String]
    def iops: Optional[Integer]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def volumeType: Optional[zio.aws.ec2.model.VolumeType]
    def fastRestored: Optional[Boolean]
    def multiAttachEnabled: Optional[Boolean]
    def throughput: Optional[Integer]
    def getAttachments: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.VolumeAttachment.ReadOnly
    ]] = AwsError.unwrapOptionField("attachments", attachments)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getCreateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("size", size)
    def getSnapshotId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.VolumeState] =
      AwsError.unwrapOptionField("state", state)
    def getVolumeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("volumeId", volumeId)
    def getIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("iops", iops)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVolumeType: ZIO[Any, AwsError, zio.aws.ec2.model.VolumeType] =
      AwsError.unwrapOptionField("volumeType", volumeType)
    def getFastRestored: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("fastRestored", fastRestored)
    def getMultiAttachEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("multiAttachEnabled", multiAttachEnabled)
    def getThroughput: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("throughput", throughput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Volume
  ) extends zio.aws.ec2.model.Volume.ReadOnly {
    override val attachments
        : Optional[List[zio.aws.ec2.model.VolumeAttachment.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.VolumeAttachment.wrap(item)
          }.toList
        )
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val createTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val encrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => value: Boolean)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val outpostArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.outpostArn())
      .map(value => value: String)
    override val size: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.size())
      .map(value => value: Integer)
    override val snapshotId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => value: String)
    override val state: Optional[zio.aws.ec2.model.VolumeState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.VolumeState.wrap(value))
    override val volumeId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeId())
      .map(value => value: String)
    override val iops: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: Integer)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val volumeType: Optional[zio.aws.ec2.model.VolumeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeType())
        .map(value => zio.aws.ec2.model.VolumeType.wrap(value))
    override val fastRestored: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.fastRestored())
      .map(value => value: Boolean)
    override val multiAttachEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.multiAttachEnabled())
      .map(value => value: Boolean)
    override val throughput: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.throughput())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Volume
  ): zio.aws.ec2.model.Volume.ReadOnly = new Wrapper(impl)
}
