package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResetAddressAttributeResponse(
    address: Optional[zio.aws.ec2.model.AddressAttribute] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ResetAddressAttributeResponse = {
    import ResetAddressAttributeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ResetAddressAttributeResponse
      .builder()
      .optionallyWith(address.map(value => value.buildAwsValue()))(_.address)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ResetAddressAttributeResponse.ReadOnly =
    zio.aws.ec2.model.ResetAddressAttributeResponse.wrap(buildAwsValue())
}
object ResetAddressAttributeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ResetAddressAttributeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ResetAddressAttributeResponse =
      zio.aws.ec2.model
        .ResetAddressAttributeResponse(address.map(value => value.asEditable))
    def address: Optional[zio.aws.ec2.model.AddressAttribute.ReadOnly]
    def getAddress
        : ZIO[Any, AwsError, zio.aws.ec2.model.AddressAttribute.ReadOnly] =
      AwsError.unwrapOptionField("address", address)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ResetAddressAttributeResponse
  ) extends zio.aws.ec2.model.ResetAddressAttributeResponse.ReadOnly {
    override val address
        : Optional[zio.aws.ec2.model.AddressAttribute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.address())
        .map(value => zio.aws.ec2.model.AddressAttribute.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ResetAddressAttributeResponse
  ): zio.aws.ec2.model.ResetAddressAttributeResponse.ReadOnly = new Wrapper(
    impl
  )
}
