package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TrafficMirrorFilterId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyTrafficMirrorFilterNetworkServicesRequest(
    trafficMirrorFilterId: TrafficMirrorFilterId,
    addNetworkServices: Optional[
      Iterable[zio.aws.ec2.model.TrafficMirrorNetworkService]
    ] = Optional.Absent,
    removeNetworkServices: Optional[
      Iterable[zio.aws.ec2.model.TrafficMirrorNetworkService]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterNetworkServicesRequest = {
    import ModifyTrafficMirrorFilterNetworkServicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterNetworkServicesRequest
      .builder()
      .trafficMirrorFilterId(
        TrafficMirrorFilterId.unwrap(trafficMirrorFilterId): java.lang.String
      )
      .optionallyWith(
        addNetworkServices.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.addNetworkServicesWithStrings)
      .optionallyWith(
        removeNetworkServices.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.removeNetworkServicesWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyTrafficMirrorFilterNetworkServicesRequest.ReadOnly =
    zio.aws.ec2.model.ModifyTrafficMirrorFilterNetworkServicesRequest
      .wrap(buildAwsValue())
}
object ModifyTrafficMirrorFilterNetworkServicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterNetworkServicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ModifyTrafficMirrorFilterNetworkServicesRequest =
      zio.aws.ec2.model.ModifyTrafficMirrorFilterNetworkServicesRequest(
        trafficMirrorFilterId,
        addNetworkServices.map(value => value),
        removeNetworkServices.map(value => value)
      )
    def trafficMirrorFilterId: TrafficMirrorFilterId
    def addNetworkServices
        : Optional[List[zio.aws.ec2.model.TrafficMirrorNetworkService]]
    def removeNetworkServices
        : Optional[List[zio.aws.ec2.model.TrafficMirrorNetworkService]]
    def getTrafficMirrorFilterId: ZIO[Any, Nothing, TrafficMirrorFilterId] =
      ZIO.succeed(trafficMirrorFilterId)
    def getAddNetworkServices: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TrafficMirrorNetworkService
    ]] = AwsError.unwrapOptionField("addNetworkServices", addNetworkServices)
    def getRemoveNetworkServices: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TrafficMirrorNetworkService
    ]] =
      AwsError.unwrapOptionField("removeNetworkServices", removeNetworkServices)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterNetworkServicesRequest
  ) extends zio.aws.ec2.model.ModifyTrafficMirrorFilterNetworkServicesRequest.ReadOnly {
    override val trafficMirrorFilterId: TrafficMirrorFilterId =
      zio.aws.ec2.model.primitives
        .TrafficMirrorFilterId(impl.trafficMirrorFilterId())
    override val addNetworkServices
        : Optional[List[zio.aws.ec2.model.TrafficMirrorNetworkService]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addNetworkServices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TrafficMirrorNetworkService.wrap(item)
          }.toList
        )
    override val removeNetworkServices
        : Optional[List[zio.aws.ec2.model.TrafficMirrorNetworkService]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeNetworkServices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TrafficMirrorNetworkService.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterNetworkServicesRequest
  ): zio.aws.ec2.model.ModifyTrafficMirrorFilterNetworkServicesRequest.ReadOnly =
    new Wrapper(impl)
}
