package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.MemorySize
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MemoryInfo(sizeInMiB: Optional[MemorySize] = Optional.Absent) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.MemoryInfo = {
    import MemoryInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.MemoryInfo
      .builder()
      .optionallyWith(
        sizeInMiB.map(value => MemorySize.unwrap(value): java.lang.Long)
      )(_.sizeInMiB)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.MemoryInfo.ReadOnly =
    zio.aws.ec2.model.MemoryInfo.wrap(buildAwsValue())
}
object MemoryInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.MemoryInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.MemoryInfo =
      zio.aws.ec2.model.MemoryInfo(sizeInMiB.map(value => value))
    def sizeInMiB: Optional[MemorySize]
    def getSizeInMiB: ZIO[Any, AwsError, MemorySize] =
      AwsError.unwrapOptionField("sizeInMiB", sizeInMiB)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.MemoryInfo
  ) extends zio.aws.ec2.model.MemoryInfo.ReadOnly {
    override val sizeInMiB: Optional[MemorySize] = zio.aws.core.internal
      .optionalFromNullable(impl.sizeInMiB())
      .map(value => zio.aws.ec2.model.primitives.MemorySize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.MemoryInfo
  ): zio.aws.ec2.model.MemoryInfo.ReadOnly = new Wrapper(impl)
}
