package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait IpamResourceDiscoveryState {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState
}
object IpamResourceDiscoveryState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState
  ): zio.aws.ec2.model.IpamResourceDiscoveryState = value match {
    case software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState.CREATE_IN_PROGRESS =>
      val r = `create-in-progress`
      r
    case software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState.CREATE_COMPLETE =>
      val r = `create-complete`
      r
    case software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState.CREATE_FAILED =>
      val r = `create-failed`
      r
    case software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState.MODIFY_IN_PROGRESS =>
      val r = `modify-in-progress`
      r
    case software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState.MODIFY_COMPLETE =>
      val r = `modify-complete`
      r
    case software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState.MODIFY_FAILED =>
      val r = `modify-failed`
      r
    case software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState.DELETE_IN_PROGRESS =>
      val r = `delete-in-progress`
      r
    case software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState.DELETE_COMPLETE =>
      val r = `delete-complete`
      r
    case software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState.DELETE_FAILED =>
      val r = `delete-failed`
      r
    case software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState.ISOLATE_IN_PROGRESS =>
      val r = `isolate-in-progress`
      r
    case software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState.ISOLATE_COMPLETE =>
      val r = `isolate-complete`
      r
    case software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState.RESTORE_IN_PROGRESS =>
      val r = `restore-in-progress`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.IpamResourceDiscoveryState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState =
      software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState.UNKNOWN_TO_SDK_VERSION
  }
  case object `create-in-progress`
      extends zio.aws.ec2.model.IpamResourceDiscoveryState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState =
      software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState.CREATE_IN_PROGRESS
  }
  case object `create-complete`
      extends zio.aws.ec2.model.IpamResourceDiscoveryState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState =
      software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState.CREATE_COMPLETE
  }
  case object `create-failed`
      extends zio.aws.ec2.model.IpamResourceDiscoveryState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState =
      software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState.CREATE_FAILED
  }
  case object `modify-in-progress`
      extends zio.aws.ec2.model.IpamResourceDiscoveryState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState =
      software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState.MODIFY_IN_PROGRESS
  }
  case object `modify-complete`
      extends zio.aws.ec2.model.IpamResourceDiscoveryState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState =
      software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState.MODIFY_COMPLETE
  }
  case object `modify-failed`
      extends zio.aws.ec2.model.IpamResourceDiscoveryState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState =
      software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState.MODIFY_FAILED
  }
  case object `delete-in-progress`
      extends zio.aws.ec2.model.IpamResourceDiscoveryState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState =
      software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState.DELETE_IN_PROGRESS
  }
  case object `delete-complete`
      extends zio.aws.ec2.model.IpamResourceDiscoveryState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState =
      software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState.DELETE_COMPLETE
  }
  case object `delete-failed`
      extends zio.aws.ec2.model.IpamResourceDiscoveryState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState =
      software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState.DELETE_FAILED
  }
  case object `isolate-in-progress`
      extends zio.aws.ec2.model.IpamResourceDiscoveryState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState =
      software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState.ISOLATE_IN_PROGRESS
  }
  case object `isolate-complete`
      extends zio.aws.ec2.model.IpamResourceDiscoveryState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState =
      software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState.ISOLATE_COMPLETE
  }
  case object `restore-in-progress`
      extends zio.aws.ec2.model.IpamResourceDiscoveryState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState =
      software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryState.RESTORE_IN_PROGRESS
  }
}
