package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, IpamPoolCidrId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IpamPoolCidr(
    cidr: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.IpamPoolCidrState] = Optional.Absent,
    failureReason: Optional[zio.aws.ec2.model.IpamPoolCidrFailureReason] =
      Optional.Absent,
    ipamPoolCidrId: Optional[IpamPoolCidrId] = Optional.Absent,
    netmaskLength: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.IpamPoolCidr = {
    import IpamPoolCidr.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IpamPoolCidr
      .builder()
      .optionallyWith(cidr.map(value => value: java.lang.String))(_.cidr)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(failureReason.map(value => value.buildAwsValue()))(
        _.failureReason
      )
      .optionallyWith(
        ipamPoolCidrId.map(value =>
          IpamPoolCidrId.unwrap(value): java.lang.String
        )
      )(_.ipamPoolCidrId)
      .optionallyWith(netmaskLength.map(value => value: java.lang.Integer))(
        _.netmaskLength
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IpamPoolCidr.ReadOnly =
    zio.aws.ec2.model.IpamPoolCidr.wrap(buildAwsValue())
}
object IpamPoolCidr {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.IpamPoolCidr] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IpamPoolCidr =
      zio.aws.ec2.model.IpamPoolCidr(
        cidr.map(value => value),
        state.map(value => value),
        failureReason.map(value => value.asEditable),
        ipamPoolCidrId.map(value => value),
        netmaskLength.map(value => value)
      )
    def cidr: Optional[String]
    def state: Optional[zio.aws.ec2.model.IpamPoolCidrState]
    def failureReason
        : Optional[zio.aws.ec2.model.IpamPoolCidrFailureReason.ReadOnly]
    def ipamPoolCidrId: Optional[IpamPoolCidrId]
    def netmaskLength: Optional[Integer]
    def getCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidr", cidr)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.IpamPoolCidrState] =
      AwsError.unwrapOptionField("state", state)
    def getFailureReason: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.IpamPoolCidrFailureReason.ReadOnly
    ] = AwsError.unwrapOptionField("failureReason", failureReason)
    def getIpamPoolCidrId: ZIO[Any, AwsError, IpamPoolCidrId] =
      AwsError.unwrapOptionField("ipamPoolCidrId", ipamPoolCidrId)
    def getNetmaskLength: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("netmaskLength", netmaskLength)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IpamPoolCidr
  ) extends zio.aws.ec2.model.IpamPoolCidr.ReadOnly {
    override val cidr: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidr())
      .map(value => value: String)
    override val state: Optional[zio.aws.ec2.model.IpamPoolCidrState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.IpamPoolCidrState.wrap(value))
    override val failureReason
        : Optional[zio.aws.ec2.model.IpamPoolCidrFailureReason.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureReason())
        .map(value => zio.aws.ec2.model.IpamPoolCidrFailureReason.wrap(value))
    override val ipamPoolCidrId: Optional[IpamPoolCidrId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipamPoolCidrId())
        .map(value => zio.aws.ec2.model.primitives.IpamPoolCidrId(value))
    override val netmaskLength: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.netmaskLength())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IpamPoolCidr
  ): zio.aws.ec2.model.IpamPoolCidr.ReadOnly = new Wrapper(impl)
}
