package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IntegrateServices(
    athenaIntegrations: Optional[
      Iterable[zio.aws.ec2.model.AthenaIntegration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.IntegrateServices = {
    import IntegrateServices.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IntegrateServices
      .builder()
      .optionallyWith(
        athenaIntegrations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.athenaIntegrations)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IntegrateServices.ReadOnly =
    zio.aws.ec2.model.IntegrateServices.wrap(buildAwsValue())
}
object IntegrateServices {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.IntegrateServices
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IntegrateServices =
      zio.aws.ec2.model.IntegrateServices(
        athenaIntegrations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def athenaIntegrations
        : Optional[List[zio.aws.ec2.model.AthenaIntegration.ReadOnly]]
    def getAthenaIntegrations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AthenaIntegration.ReadOnly
    ]] = AwsError.unwrapOptionField("athenaIntegrations", athenaIntegrations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IntegrateServices
  ) extends zio.aws.ec2.model.IntegrateServices.ReadOnly {
    override val athenaIntegrations
        : Optional[List[zio.aws.ec2.model.AthenaIntegration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.athenaIntegrations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AthenaIntegration.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IntegrateServices
  ): zio.aws.ec2.model.IntegrateServices.ReadOnly = new Wrapper(impl)
}
