package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  TransitGatewayMaxResults,
  TransitGatewayPolicyTableId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetTransitGatewayPolicyTableEntriesRequest(
    transitGatewayPolicyTableId: TransitGatewayPolicyTableId,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[TransitGatewayMaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableEntriesRequest = {
    import GetTransitGatewayPolicyTableEntriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableEntriesRequest
      .builder()
      .transitGatewayPolicyTableId(
        TransitGatewayPolicyTableId.unwrap(
          transitGatewayPolicyTableId
        ): java.lang.String
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => TransitGatewayMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetTransitGatewayPolicyTableEntriesRequest.ReadOnly =
    zio.aws.ec2.model.GetTransitGatewayPolicyTableEntriesRequest
      .wrap(buildAwsValue())
}
object GetTransitGatewayPolicyTableEntriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableEntriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.GetTransitGatewayPolicyTableEntriesRequest =
      zio.aws.ec2.model.GetTransitGatewayPolicyTableEntriesRequest(
        transitGatewayPolicyTableId,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def transitGatewayPolicyTableId: TransitGatewayPolicyTableId
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[TransitGatewayMaxResults]
    def nextToken: Optional[String]
    def getTransitGatewayPolicyTableId
        : ZIO[Any, Nothing, TransitGatewayPolicyTableId] =
      ZIO.succeed(transitGatewayPolicyTableId)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, TransitGatewayMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableEntriesRequest
  ) extends zio.aws.ec2.model.GetTransitGatewayPolicyTableEntriesRequest.ReadOnly {
    override val transitGatewayPolicyTableId: TransitGatewayPolicyTableId =
      zio.aws.ec2.model.primitives
        .TransitGatewayPolicyTableId(impl.transitGatewayPolicyTableId())
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[TransitGatewayMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.TransitGatewayMaxResults(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableEntriesRequest
  ): zio.aws.ec2.model.GetTransitGatewayPolicyTableEntriesRequest.ReadOnly =
    new Wrapper(impl)
}
