package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{CoipPoolMaxResults, Ipv4PoolCoipId}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetCoipPoolUsageRequest(
    poolId: Ipv4PoolCoipId,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[CoipPoolMaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetCoipPoolUsageRequest = {
    import GetCoipPoolUsageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetCoipPoolUsageRequest
      .builder()
      .poolId(Ipv4PoolCoipId.unwrap(poolId): java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => CoipPoolMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetCoipPoolUsageRequest.ReadOnly =
    zio.aws.ec2.model.GetCoipPoolUsageRequest.wrap(buildAwsValue())
}
object GetCoipPoolUsageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetCoipPoolUsageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetCoipPoolUsageRequest =
      zio.aws.ec2.model.GetCoipPoolUsageRequest(
        poolId,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def poolId: Ipv4PoolCoipId
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[CoipPoolMaxResults]
    def nextToken: Optional[String]
    def getPoolId: ZIO[Any, Nothing, Ipv4PoolCoipId] = ZIO.succeed(poolId)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, CoipPoolMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetCoipPoolUsageRequest
  ) extends zio.aws.ec2.model.GetCoipPoolUsageRequest.ReadOnly {
    override val poolId: Ipv4PoolCoipId =
      zio.aws.ec2.model.primitives.Ipv4PoolCoipId(impl.poolId())
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[CoipPoolMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value => zio.aws.ec2.model.primitives.CoipPoolMaxResults(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetCoipPoolUsageRequest
  ): zio.aws.ec2.model.GetCoipPoolUsageRequest.ReadOnly = new Wrapper(impl)
}
