package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait EbsEncryptionSupport {
  def unwrap: software.amazon.awssdk.services.ec2.model.EbsEncryptionSupport
}
object EbsEncryptionSupport {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.EbsEncryptionSupport
  ): zio.aws.ec2.model.EbsEncryptionSupport = value match {
    case software.amazon.awssdk.services.ec2.model.EbsEncryptionSupport.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.EbsEncryptionSupport.UNSUPPORTED =>
      val r = unsupported
      r
    case software.amazon.awssdk.services.ec2.model.EbsEncryptionSupport.SUPPORTED =>
      val r = supported
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.EbsEncryptionSupport {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.EbsEncryptionSupport =
      software.amazon.awssdk.services.ec2.model.EbsEncryptionSupport.UNKNOWN_TO_SDK_VERSION
  }
  case object unsupported extends zio.aws.ec2.model.EbsEncryptionSupport {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.EbsEncryptionSupport =
      software.amazon.awssdk.services.ec2.model.EbsEncryptionSupport.UNSUPPORTED
  }
  case object supported extends zio.aws.ec2.model.EbsEncryptionSupport {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.EbsEncryptionSupport =
      software.amazon.awssdk.services.ec2.model.EbsEncryptionSupport.SUPPORTED
  }
}
