package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpnGatewayId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVpnGatewaysRequest(
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    vpnGatewayIds: Optional[Iterable[VpnGatewayId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysRequest = {
    import DescribeVpnGatewaysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        vpnGatewayIds.map(value =>
          value.map { item =>
            VpnGatewayId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.vpnGatewayIds)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeVpnGatewaysRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVpnGatewaysRequest.wrap(buildAwsValue())
}
object DescribeVpnGatewaysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVpnGatewaysRequest =
      zio.aws.ec2.model.DescribeVpnGatewaysRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpnGatewayIds.map(value => value)
      )
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def vpnGatewayIds: Optional[List[VpnGatewayId]]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getVpnGatewayIds: ZIO[Any, AwsError, List[VpnGatewayId]] =
      AwsError.unwrapOptionField("vpnGatewayIds", vpnGatewayIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysRequest
  ) extends zio.aws.ec2.model.DescribeVpnGatewaysRequest.ReadOnly {
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val vpnGatewayIds: Optional[List[VpnGatewayId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpnGatewayIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.VpnGatewayId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysRequest
  ): zio.aws.ec2.model.DescribeVpnGatewaysRequest.ReadOnly = new Wrapper(impl)
}
