package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VolumeId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeVolumeAttributeRequest(
    attribute: zio.aws.ec2.model.VolumeAttributeName,
    volumeId: VolumeId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeRequest = {
    import DescribeVolumeAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeRequest
      .builder()
      .attribute(attribute.unwrap)
      .volumeId(VolumeId.unwrap(volumeId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeVolumeAttributeRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVolumeAttributeRequest.wrap(buildAwsValue())
}
object DescribeVolumeAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVolumeAttributeRequest =
      zio.aws.ec2.model.DescribeVolumeAttributeRequest(attribute, volumeId)
    def attribute: zio.aws.ec2.model.VolumeAttributeName
    def volumeId: VolumeId
    def getAttribute: ZIO[Any, Nothing, zio.aws.ec2.model.VolumeAttributeName] =
      ZIO.succeed(attribute)
    def getVolumeId: ZIO[Any, Nothing, VolumeId] = ZIO.succeed(volumeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeRequest
  ) extends zio.aws.ec2.model.DescribeVolumeAttributeRequest.ReadOnly {
    override val attribute: zio.aws.ec2.model.VolumeAttributeName =
      zio.aws.ec2.model.VolumeAttributeName.wrap(impl.attribute())
    override val volumeId: VolumeId =
      zio.aws.ec2.model.primitives.VolumeId(impl.volumeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeRequest
  ): zio.aws.ec2.model.DescribeVolumeAttributeRequest.ReadOnly = new Wrapper(
    impl
  )
}
