package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SpotFleetRequestId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeSpotFleetRequestsRequest(
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    spotFleetRequestIds: Optional[Iterable[SpotFleetRequestId]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsRequest = {
    import DescribeSpotFleetRequestsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsRequest
      .builder()
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        spotFleetRequestIds.map(value =>
          value.map { item =>
            SpotFleetRequestId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.spotFleetRequestIds)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeSpotFleetRequestsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeSpotFleetRequestsRequest.wrap(buildAwsValue())
}
object DescribeSpotFleetRequestsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSpotFleetRequestsRequest =
      zio.aws.ec2.model.DescribeSpotFleetRequestsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        spotFleetRequestIds.map(value => value)
      )
    def maxResults: Optional[Integer]
    def nextToken: Optional[String]
    def spotFleetRequestIds: Optional[List[SpotFleetRequestId]]
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSpotFleetRequestIds: ZIO[Any, AwsError, List[SpotFleetRequestId]] =
      AwsError.unwrapOptionField("spotFleetRequestIds", spotFleetRequestIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsRequest
  ) extends zio.aws.ec2.model.DescribeSpotFleetRequestsRequest.ReadOnly {
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val spotFleetRequestIds: Optional[List[SpotFleetRequestId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spotFleetRequestIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.SpotFleetRequestId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsRequest
  ): zio.aws.ec2.model.DescribeSpotFleetRequestsRequest.ReadOnly = new Wrapper(
    impl
  )
}
