package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NextToken,
  DescribeReplaceRootVolumeTasksMaxResults,
  ReplaceRootVolumeTaskId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeReplaceRootVolumeTasksRequest(
    replaceRootVolumeTaskIds: Optional[Iterable[ReplaceRootVolumeTaskId]] =
      Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[DescribeReplaceRootVolumeTasksMaxResults] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeReplaceRootVolumeTasksRequest = {
    import DescribeReplaceRootVolumeTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeReplaceRootVolumeTasksRequest
      .builder()
      .optionallyWith(
        replaceRootVolumeTaskIds.map(value =>
          value.map { item =>
            ReplaceRootVolumeTaskId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.replaceRootVolumeTaskIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          DescribeReplaceRootVolumeTasksMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeReplaceRootVolumeTasksRequest.ReadOnly =
    zio.aws.ec2.model.DescribeReplaceRootVolumeTasksRequest
      .wrap(buildAwsValue())
}
object DescribeReplaceRootVolumeTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeReplaceRootVolumeTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeReplaceRootVolumeTasksRequest =
      zio.aws.ec2.model.DescribeReplaceRootVolumeTasksRequest(
        replaceRootVolumeTaskIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def replaceRootVolumeTaskIds: Optional[List[ReplaceRootVolumeTaskId]]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[DescribeReplaceRootVolumeTasksMaxResults]
    def nextToken: Optional[NextToken]
    def getReplaceRootVolumeTaskIds
        : ZIO[Any, AwsError, List[ReplaceRootVolumeTaskId]] = AwsError
      .unwrapOptionField("replaceRootVolumeTaskIds", replaceRootVolumeTaskIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeReplaceRootVolumeTasksMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeReplaceRootVolumeTasksRequest
  ) extends zio.aws.ec2.model.DescribeReplaceRootVolumeTasksRequest.ReadOnly {
    override val replaceRootVolumeTaskIds
        : Optional[List[ReplaceRootVolumeTaskId]] = zio.aws.core.internal
      .optionalFromNullable(impl.replaceRootVolumeTaskIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.ReplaceRootVolumeTaskId(item)
        }.toList
      )
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults
        : Optional[DescribeReplaceRootVolumeTasksMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeReplaceRootVolumeTasksMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeReplaceRootVolumeTasksRequest
  ): zio.aws.ec2.model.DescribeReplaceRootVolumeTasksRequest.ReadOnly =
    new Wrapper(impl)
}
