package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribePrincipalIdFormatResponse(
    principals: Optional[Iterable[zio.aws.ec2.model.PrincipalIdFormat]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatResponse = {
    import DescribePrincipalIdFormatResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatResponse
      .builder()
      .optionallyWith(
        principals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.principals)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribePrincipalIdFormatResponse.ReadOnly =
    zio.aws.ec2.model.DescribePrincipalIdFormatResponse.wrap(buildAwsValue())
}
object DescribePrincipalIdFormatResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribePrincipalIdFormatResponse =
      zio.aws.ec2.model.DescribePrincipalIdFormatResponse(
        principals.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def principals: Optional[List[zio.aws.ec2.model.PrincipalIdFormat.ReadOnly]]
    def nextToken: Optional[String]
    def getPrincipals: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.PrincipalIdFormat.ReadOnly
    ]] = AwsError.unwrapOptionField("principals", principals)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatResponse
  ) extends zio.aws.ec2.model.DescribePrincipalIdFormatResponse.ReadOnly {
    override val principals
        : Optional[List[zio.aws.ec2.model.PrincipalIdFormat.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.principals())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.PrincipalIdFormat.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatResponse
  ): zio.aws.ec2.model.DescribePrincipalIdFormatResponse.ReadOnly = new Wrapper(
    impl
  )
}
