package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribePlacementGroupsResponse(
    placementGroups: Optional[Iterable[zio.aws.ec2.model.PlacementGroup]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribePlacementGroupsResponse = {
    import DescribePlacementGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribePlacementGroupsResponse
      .builder()
      .optionallyWith(
        placementGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementGroups)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribePlacementGroupsResponse.ReadOnly =
    zio.aws.ec2.model.DescribePlacementGroupsResponse.wrap(buildAwsValue())
}
object DescribePlacementGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribePlacementGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribePlacementGroupsResponse =
      zio.aws.ec2.model.DescribePlacementGroupsResponse(
        placementGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def placementGroups
        : Optional[List[zio.aws.ec2.model.PlacementGroup.ReadOnly]]
    def getPlacementGroups
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PlacementGroup.ReadOnly]] =
      AwsError.unwrapOptionField("placementGroups", placementGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribePlacementGroupsResponse
  ) extends zio.aws.ec2.model.DescribePlacementGroupsResponse.ReadOnly {
    override val placementGroups
        : Optional[List[zio.aws.ec2.model.PlacementGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placementGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.PlacementGroup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribePlacementGroupsResponse
  ): zio.aws.ec2.model.DescribePlacementGroupsResponse.ReadOnly = new Wrapper(
    impl
  )
}
