package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeNetworkInterfacesResponse(
    networkInterfaces: Optional[Iterable[zio.aws.ec2.model.NetworkInterface]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesResponse = {
    import DescribeNetworkInterfacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesResponse
      .builder()
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeNetworkInterfacesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeNetworkInterfacesResponse.wrap(buildAwsValue())
}
object DescribeNetworkInterfacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeNetworkInterfacesResponse =
      zio.aws.ec2.model.DescribeNetworkInterfacesResponse(
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def networkInterfaces
        : Optional[List[zio.aws.ec2.model.NetworkInterface.ReadOnly]]
    def nextToken: Optional[String]
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.NetworkInterface.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesResponse
  ) extends zio.aws.ec2.model.DescribeNetworkInterfacesResponse.ReadOnly {
    override val networkInterfaces
        : Optional[List[zio.aws.ec2.model.NetworkInterface.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaces())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.NetworkInterface.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesResponse
  ): zio.aws.ec2.model.DescribeNetworkInterfacesResponse.ReadOnly = new Wrapper(
    impl
  )
}
