package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeCapacityReservationFleetsResponse(
    capacityReservationFleets: Optional[
      Iterable[zio.aws.ec2.model.CapacityReservationFleet]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsResponse = {
    import DescribeCapacityReservationFleetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsResponse
      .builder()
      .optionallyWith(
        capacityReservationFleets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.capacityReservationFleets)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeCapacityReservationFleetsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeCapacityReservationFleetsResponse
      .wrap(buildAwsValue())
}
object DescribeCapacityReservationFleetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeCapacityReservationFleetsResponse =
      zio.aws.ec2.model.DescribeCapacityReservationFleetsResponse(
        capacityReservationFleets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def capacityReservationFleets
        : Optional[List[zio.aws.ec2.model.CapacityReservationFleet.ReadOnly]]
    def nextToken: Optional[String]
    def getCapacityReservationFleets: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.CapacityReservationFleet.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "capacityReservationFleets",
      capacityReservationFleets
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsResponse
  ) extends zio.aws.ec2.model.DescribeCapacityReservationFleetsResponse.ReadOnly {
    override val capacityReservationFleets
        : Optional[List[zio.aws.ec2.model.CapacityReservationFleet.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityReservationFleets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.CapacityReservationFleet.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsResponse
  ): zio.aws.ec2.model.DescribeCapacityReservationFleetsResponse.ReadOnly =
    new Wrapper(impl)
}
