package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Ipv4PoolEc2Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeprovisionPublicIpv4PoolCidrRequest(
    poolId: Ipv4PoolEc2Id,
    cidr: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeprovisionPublicIpv4PoolCidrRequest = {
    import DeprovisionPublicIpv4PoolCidrRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeprovisionPublicIpv4PoolCidrRequest
      .builder()
      .poolId(Ipv4PoolEc2Id.unwrap(poolId): java.lang.String)
      .cidr(cidr: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeprovisionPublicIpv4PoolCidrRequest.ReadOnly =
    zio.aws.ec2.model.DeprovisionPublicIpv4PoolCidrRequest.wrap(buildAwsValue())
}
object DeprovisionPublicIpv4PoolCidrRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeprovisionPublicIpv4PoolCidrRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeprovisionPublicIpv4PoolCidrRequest =
      zio.aws.ec2.model.DeprovisionPublicIpv4PoolCidrRequest(poolId, cidr)
    def poolId: Ipv4PoolEc2Id
    def cidr: String
    def getPoolId: ZIO[Any, Nothing, Ipv4PoolEc2Id] = ZIO.succeed(poolId)
    def getCidr: ZIO[Any, Nothing, String] = ZIO.succeed(cidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeprovisionPublicIpv4PoolCidrRequest
  ) extends zio.aws.ec2.model.DeprovisionPublicIpv4PoolCidrRequest.ReadOnly {
    override val poolId: Ipv4PoolEc2Id =
      zio.aws.ec2.model.primitives.Ipv4PoolEc2Id(impl.poolId())
    override val cidr: String = impl.cidr(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeprovisionPublicIpv4PoolCidrRequest
  ): zio.aws.ec2.model.DeprovisionPublicIpv4PoolCidrRequest.ReadOnly =
    new Wrapper(impl)
}
