package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpnConnectionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteVpnConnectionRequest(vpnConnectionId: VpnConnectionId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRequest = {
    import DeleteVpnConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRequest
      .builder()
      .vpnConnectionId(
        VpnConnectionId.unwrap(vpnConnectionId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteVpnConnectionRequest.ReadOnly =
    zio.aws.ec2.model.DeleteVpnConnectionRequest.wrap(buildAwsValue())
}
object DeleteVpnConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteVpnConnectionRequest =
      zio.aws.ec2.model.DeleteVpnConnectionRequest(vpnConnectionId)
    def vpnConnectionId: VpnConnectionId
    def getVpnConnectionId: ZIO[Any, Nothing, VpnConnectionId] =
      ZIO.succeed(vpnConnectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRequest
  ) extends zio.aws.ec2.model.DeleteVpnConnectionRequest.ReadOnly {
    override val vpnConnectionId: VpnConnectionId =
      zio.aws.ec2.model.primitives.VpnConnectionId(impl.vpnConnectionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRequest
  ): zio.aws.ec2.model.DeleteVpnConnectionRequest.ReadOnly = new Wrapper(impl)
}
