package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TrafficMirrorFilterRuleIdWithResolver
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteTrafficMirrorFilterRuleRequest(
    trafficMirrorFilterRuleId: TrafficMirrorFilterRuleIdWithResolver
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleRequest = {
    import DeleteTrafficMirrorFilterRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleRequest
      .builder()
      .trafficMirrorFilterRuleId(
        TrafficMirrorFilterRuleIdWithResolver.unwrap(
          trafficMirrorFilterRuleId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleRequest.ReadOnly =
    zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleRequest.wrap(buildAwsValue())
}
object DeleteTrafficMirrorFilterRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleRequest =
      zio.aws.ec2.model
        .DeleteTrafficMirrorFilterRuleRequest(trafficMirrorFilterRuleId)
    def trafficMirrorFilterRuleId: TrafficMirrorFilterRuleIdWithResolver
    def getTrafficMirrorFilterRuleId
        : ZIO[Any, Nothing, TrafficMirrorFilterRuleIdWithResolver] =
      ZIO.succeed(trafficMirrorFilterRuleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleRequest
  ) extends zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleRequest.ReadOnly {
    override val trafficMirrorFilterRuleId
        : TrafficMirrorFilterRuleIdWithResolver = zio.aws.ec2.model.primitives
      .TrafficMirrorFilterRuleIdWithResolver(impl.trafficMirrorFilterRuleId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleRequest
  ): zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleRequest.ReadOnly =
    new Wrapper(impl)
}
