package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TrafficMirrorFilterId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteTrafficMirrorFilterRequest(
    trafficMirrorFilterId: TrafficMirrorFilterId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRequest = {
    import DeleteTrafficMirrorFilterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRequest
      .builder()
      .trafficMirrorFilterId(
        TrafficMirrorFilterId.unwrap(trafficMirrorFilterId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteTrafficMirrorFilterRequest.ReadOnly =
    zio.aws.ec2.model.DeleteTrafficMirrorFilterRequest.wrap(buildAwsValue())
}
object DeleteTrafficMirrorFilterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTrafficMirrorFilterRequest =
      zio.aws.ec2.model.DeleteTrafficMirrorFilterRequest(trafficMirrorFilterId)
    def trafficMirrorFilterId: TrafficMirrorFilterId
    def getTrafficMirrorFilterId: ZIO[Any, Nothing, TrafficMirrorFilterId] =
      ZIO.succeed(trafficMirrorFilterId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRequest
  ) extends zio.aws.ec2.model.DeleteTrafficMirrorFilterRequest.ReadOnly {
    override val trafficMirrorFilterId: TrafficMirrorFilterId =
      zio.aws.ec2.model.primitives
        .TrafficMirrorFilterId(impl.trafficMirrorFilterId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRequest
  ): zio.aws.ec2.model.DeleteTrafficMirrorFilterRequest.ReadOnly = new Wrapper(
    impl
  )
}
