package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SubnetId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteSubnetRequest(subnetId: SubnetId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteSubnetRequest = {
    import DeleteSubnetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteSubnetRequest
      .builder()
      .subnetId(SubnetId.unwrap(subnetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteSubnetRequest.ReadOnly =
    zio.aws.ec2.model.DeleteSubnetRequest.wrap(buildAwsValue())
}
object DeleteSubnetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteSubnetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteSubnetRequest =
      zio.aws.ec2.model.DeleteSubnetRequest(subnetId)
    def subnetId: SubnetId
    def getSubnetId: ZIO[Any, Nothing, SubnetId] = ZIO.succeed(subnetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteSubnetRequest
  ) extends zio.aws.ec2.model.DeleteSubnetRequest.ReadOnly {
    override val subnetId: SubnetId =
      zio.aws.ec2.model.primitives.SubnetId(impl.subnetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteSubnetRequest
  ): zio.aws.ec2.model.DeleteSubnetRequest.ReadOnly = new Wrapper(impl)
}
