package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteInstanceEventWindowResponse(
    instanceEventWindowState: Optional[
      zio.aws.ec2.model.InstanceEventWindowStateChange
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteInstanceEventWindowResponse = {
    import DeleteInstanceEventWindowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteInstanceEventWindowResponse
      .builder()
      .optionallyWith(
        instanceEventWindowState.map(value => value.buildAwsValue())
      )(_.instanceEventWindowState)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteInstanceEventWindowResponse.ReadOnly =
    zio.aws.ec2.model.DeleteInstanceEventWindowResponse.wrap(buildAwsValue())
}
object DeleteInstanceEventWindowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteInstanceEventWindowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteInstanceEventWindowResponse =
      zio.aws.ec2.model.DeleteInstanceEventWindowResponse(
        instanceEventWindowState.map(value => value.asEditable)
      )
    def instanceEventWindowState
        : Optional[zio.aws.ec2.model.InstanceEventWindowStateChange.ReadOnly]
    def getInstanceEventWindowState: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceEventWindowStateChange.ReadOnly
    ] = AwsError.unwrapOptionField(
      "instanceEventWindowState",
      instanceEventWindowState
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteInstanceEventWindowResponse
  ) extends zio.aws.ec2.model.DeleteInstanceEventWindowResponse.ReadOnly {
    override val instanceEventWindowState
        : Optional[zio.aws.ec2.model.InstanceEventWindowStateChange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceEventWindowState())
        .map(value =>
          zio.aws.ec2.model.InstanceEventWindowStateChange.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteInstanceEventWindowResponse
  ): zio.aws.ec2.model.DeleteInstanceEventWindowResponse.ReadOnly = new Wrapper(
    impl
  )
}
