package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  LocalGatewayVirtualInterfaceGroupId,
  LocalGatewayRoutetableId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest(
    localGatewayRouteTableId: LocalGatewayRoutetableId,
    localGatewayVirtualInterfaceGroupId: LocalGatewayVirtualInterfaceGroupId,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest = {
    import CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest
      .builder()
      .localGatewayRouteTableId(
        LocalGatewayRoutetableId.unwrap(
          localGatewayRouteTableId
        ): java.lang.String
      )
      .localGatewayVirtualInterfaceGroupId(
        LocalGatewayVirtualInterfaceGroupId.unwrap(
          localGatewayVirtualInterfaceGroupId
        ): java.lang.String
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest.ReadOnly =
    zio.aws.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest
      .wrap(buildAwsValue())
}
object CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest =
      zio.aws.ec2.model
        .CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest(
          localGatewayRouteTableId,
          localGatewayVirtualInterfaceGroupId,
          tagSpecifications.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def localGatewayRouteTableId: LocalGatewayRoutetableId
    def localGatewayVirtualInterfaceGroupId: LocalGatewayVirtualInterfaceGroupId
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getLocalGatewayRouteTableId
        : ZIO[Any, Nothing, LocalGatewayRoutetableId] =
      ZIO.succeed(localGatewayRouteTableId)
    def getLocalGatewayVirtualInterfaceGroupId
        : ZIO[Any, Nothing, LocalGatewayVirtualInterfaceGroupId] =
      ZIO.succeed(localGatewayVirtualInterfaceGroupId)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest
  ) extends zio.aws.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest.ReadOnly {
    override val localGatewayRouteTableId: LocalGatewayRoutetableId =
      zio.aws.ec2.model.primitives
        .LocalGatewayRoutetableId(impl.localGatewayRouteTableId())
    override val localGatewayVirtualInterfaceGroupId
        : LocalGatewayVirtualInterfaceGroupId =
      zio.aws.ec2.model.primitives.LocalGatewayVirtualInterfaceGroupId(
        impl.localGatewayVirtualInterfaceGroupId()
      )
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest
  ): zio.aws.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
