package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CancelSpotFleetRequestsError(
    code: Optional[zio.aws.ec2.model.CancelBatchErrorCode] = Optional.Absent,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsError = {
    import CancelSpotFleetRequestsError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsError
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CancelSpotFleetRequestsError.ReadOnly =
    zio.aws.ec2.model.CancelSpotFleetRequestsError.wrap(buildAwsValue())
}
object CancelSpotFleetRequestsError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelSpotFleetRequestsError =
      zio.aws.ec2.model.CancelSpotFleetRequestsError(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Optional[zio.aws.ec2.model.CancelBatchErrorCode]
    def message: Optional[String]
    def getCode: ZIO[Any, AwsError, zio.aws.ec2.model.CancelBatchErrorCode] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsError
  ) extends zio.aws.ec2.model.CancelSpotFleetRequestsError.ReadOnly {
    override val code: Optional[zio.aws.ec2.model.CancelBatchErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value => zio.aws.ec2.model.CancelBatchErrorCode.wrap(value))
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsError
  ): zio.aws.ec2.model.CancelSpotFleetRequestsError.ReadOnly = new Wrapper(impl)
}
