package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ExportVmTaskId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CancelExportTaskRequest(exportTaskId: ExportVmTaskId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelExportTaskRequest = {
    import CancelExportTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelExportTaskRequest
      .builder()
      .exportTaskId(ExportVmTaskId.unwrap(exportTaskId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CancelExportTaskRequest.ReadOnly =
    zio.aws.ec2.model.CancelExportTaskRequest.wrap(buildAwsValue())
}
object CancelExportTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelExportTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelExportTaskRequest =
      zio.aws.ec2.model.CancelExportTaskRequest(exportTaskId)
    def exportTaskId: ExportVmTaskId
    def getExportTaskId: ZIO[Any, Nothing, ExportVmTaskId] =
      ZIO.succeed(exportTaskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelExportTaskRequest
  ) extends zio.aws.ec2.model.CancelExportTaskRequest.ReadOnly {
    override val exportTaskId: ExportVmTaskId =
      zio.aws.ec2.model.primitives.ExportVmTaskId(impl.exportTaskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelExportTaskRequest
  ): zio.aws.ec2.model.CancelExportTaskRequest.ReadOnly = new Wrapper(impl)
}
