package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VerifiedAccessLogS3DestinationOptions(
    enabled: Boolean,
    bucketName: Optional[String] = Optional.Absent,
    prefix: Optional[String] = Optional.Absent,
    bucketOwner: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VerifiedAccessLogS3DestinationOptions = {
    import VerifiedAccessLogS3DestinationOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VerifiedAccessLogS3DestinationOptions
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(bucketName.map(value => value: java.lang.String))(
        _.bucketName
      )
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(bucketOwner.map(value => value: java.lang.String))(
        _.bucketOwner
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.VerifiedAccessLogS3DestinationOptions.ReadOnly =
    zio.aws.ec2.model.VerifiedAccessLogS3DestinationOptions
      .wrap(buildAwsValue())
}
object VerifiedAccessLogS3DestinationOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VerifiedAccessLogS3DestinationOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VerifiedAccessLogS3DestinationOptions =
      zio.aws.ec2.model.VerifiedAccessLogS3DestinationOptions(
        enabled,
        bucketName.map(value => value),
        prefix.map(value => value),
        bucketOwner.map(value => value)
      )
    def enabled: Boolean
    def bucketName: Optional[String]
    def prefix: Optional[String]
    def bucketOwner: Optional[String]
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getBucketName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucketName", bucketName)
    def getPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getBucketOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucketOwner", bucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessLogS3DestinationOptions
  ) extends zio.aws.ec2.model.VerifiedAccessLogS3DestinationOptions.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val bucketName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketName())
      .map(value => value: String)
    override val prefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => value: String)
    override val bucketOwner: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketOwner())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessLogS3DestinationOptions
  ): zio.aws.ec2.model.VerifiedAccessLogS3DestinationOptions.ReadOnly =
    new Wrapper(impl)
}
