package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VerifiedAccessLogCloudWatchLogsDestination(
    enabled: Optional[Boolean] = Optional.Absent,
    deliveryStatus: Optional[
      zio.aws.ec2.model.VerifiedAccessLogDeliveryStatus
    ] = Optional.Absent,
    logGroup: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VerifiedAccessLogCloudWatchLogsDestination = {
    import VerifiedAccessLogCloudWatchLogsDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VerifiedAccessLogCloudWatchLogsDestination
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(deliveryStatus.map(value => value.buildAwsValue()))(
        _.deliveryStatus
      )
      .optionallyWith(logGroup.map(value => value: java.lang.String))(
        _.logGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.VerifiedAccessLogCloudWatchLogsDestination.ReadOnly =
    zio.aws.ec2.model.VerifiedAccessLogCloudWatchLogsDestination
      .wrap(buildAwsValue())
}
object VerifiedAccessLogCloudWatchLogsDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VerifiedAccessLogCloudWatchLogsDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.VerifiedAccessLogCloudWatchLogsDestination =
      zio.aws.ec2.model.VerifiedAccessLogCloudWatchLogsDestination(
        enabled.map(value => value),
        deliveryStatus.map(value => value.asEditable),
        logGroup.map(value => value)
      )
    def enabled: Optional[Boolean]
    def deliveryStatus
        : Optional[zio.aws.ec2.model.VerifiedAccessLogDeliveryStatus.ReadOnly]
    def logGroup: Optional[String]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getDeliveryStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessLogDeliveryStatus.ReadOnly
    ] = AwsError.unwrapOptionField("deliveryStatus", deliveryStatus)
    def getLogGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logGroup", logGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessLogCloudWatchLogsDestination
  ) extends zio.aws.ec2.model.VerifiedAccessLogCloudWatchLogsDestination.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val deliveryStatus
        : Optional[zio.aws.ec2.model.VerifiedAccessLogDeliveryStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deliveryStatus())
        .map(value =>
          zio.aws.ec2.model.VerifiedAccessLogDeliveryStatus.wrap(value)
        )
    override val logGroup: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.logGroup())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessLogCloudWatchLogsDestination
  ): zio.aws.ec2.model.VerifiedAccessLogCloudWatchLogsDestination.ReadOnly =
    new Wrapper(impl)
}
